/**
 * 作用：文件上传组件
 * 官网：Https://cms.nengyu.com
 * 作者：老头
 * ===========================================================================
 * 您可以使用本软件用于商业目的，但是您必须保留极品模板的版权；
 * 未经授权不允许对本程序代码以任何形式任何目的的再发布。
 * ===========================================================================
**/

;(function($)
{
	/*防止重复加载*/
	if($.fn.upload)
	{
		return false;
	}
	var index=0;
	$.fn.upload=function(opt)
	{
		var _self='ui_upload_id_'+index;
		if($(this[0]).attr("id")==undefined)
		{
			$(this[0]).attr("id",_self);
		}
		else
		{
			_self=this.get(0).id;
		};
		
		this.path=function()
		{
			var root='';
			$('script[src*=upload]').each(function()
			{
				var s=this.src;
				if(s.match(/upload[^\/]*\.js/i)){root=s.replace(/[\?#].*$/, '').replace(/(^|[\/\\])[^\/]*$/, '$1');return false;}
			});
			return root;
		};
		
		this.loadCss=function(path)
		{
			if($("#ui-uploader").length==0)
			{
				$('head').append('<link id="ui-uploader" rel="stylesheet" type="text/css" href="'+path+'upload.css?v='+Math.random()+'" />');
			}
		};
		
		/*加载Css*/
		this.loadCss(this.path());

		var defaults=
		{
			accept:'',
			maxsize:'',
			minsize:'',
			type:'',
			url:'',
			file:'',
			params:'',
			multiple:true,
			key:'gid',
			target:[],
			auto:true,
			zip:false,
			success:null
		};
		
		var config=$.extend({},defaults,opt);

		return this.each(function()
		{
			index++;
			var that=this;

			that.accept=config.accept || $(that).data("accept") || $(that).attr("accept") || 'image';
			that.maxsize=config.maxsize || $(that).data("maxsize") || $(that).attr("maxsize") || 0;
			that.minsize=config.minsize || $(that).data("minsize") || $(that).attr("minsize") || 102400;
			that.type=config.type || $(that).data("type") || $(that).attr("type") || 'one';
			that.url=config.url || $(that).data("url") || $(that).attr("url") || '';
			that.file=config.file || $(that).data("file") || $(that).attr("file") || 'file';
			that.params=config.params || $(that).data("params") || $(that).attr("params") || {};
			that.multiple=config.multiple;
			that.auto=config.auto;
			that.zip=config.zip;
			that.key=config.key;
			that.target=config.target;
			that.success=config.success;
			if(that.url=='')
			{
				ui.error('未设置上传接口');
				return;
			}

			that.fileList=[];
			that.filekey=[];
			
			that.getType=function(type,name)
			{
				var result="file";
				if(type.indexOf('image/')>=0)
				{
					return 'img';
				}
				if(type.indexOf('audio/')>=0 && (name.indexOf('.mp3')>=0))
				{
					return 'music';
				}
				if(type.indexOf('video/')>=0 && name.indexOf('.mp4')>=0)
				{
					return 'video';
				}
				return result;
			};
			
			that.getName=function(name)
			{
				if(name.indexOf(".")>=0)
				{
					var data=name.split(".");
					return name.replace("."+data[data.length-1],"");
				}
				else
				{
					return name;
				}
			};
			
			/*Base64转Blob*/
			that.dataURItoBlob=function(base64Data) 
			{
				var byteString;
				if(base64Data.split(',')[0].indexOf('base64')>=0) 
				{
					byteString= atob(base64Data.split(',')[1]);
				} 
				else 
				{
					byteString=unescape(base64Data.split(',')[1]);
				}
				var mimeString=base64Data.split(',')[0].split(':')[1].split(';')[0];
				
				var a=new Uint8Array(byteString.length);
				for(var i=0;i<byteString.length;i++) 
				{
					a[i]=byteString.charCodeAt(i);
				}
				return new Blob([a],{type:mimeString});
			};
			
			that.crop=function(that,file,type,name,filename,fileSize)
			{
				var URL=window.URL || window.webkitURL;
				var blob=URL.createObjectURL(file);
				var base64;
				var img=new Image();
				img.src=blob;
				img.onload=function()
				{
					var w=this.width;
					var h=this.height;

					var canvas=document.createElement('canvas');
					var ctx=canvas.getContext('2d');

					$(canvas).attr({width:w,height:h});
					ctx.drawImage(this,0,0,w,h);
					
					base64=canvas.toDataURL(file['type'],0.1);
					
					var data=that.dataURItoBlob(base64);
					that.ajaxUpload(
					{
						data:data,
						isblob:true,
						name:name,
						action:that.accept,
						source:that,
						success:function(e)
						{
							if(typeof that.success=="function")
							{
								that.success(that,{url:e.msg,type:type,name:that.getName(name)});
							}
						},
					});
				};
			};
			
			/*Ajax上传*/
			that.ajaxUpload=function(opt)
			{
				var data=opt.data || {};
				var params=that.params || {};
				var error=opt.error || null;
				var success=opt.success || null;
				var url=that.url || '';
				var source=opt.source || '';
				var action=opt.action || 'image';
				var isblob=opt.isblob || false;
				var name=opt.name || '';
				var size=opt.size || 0;
				var total=opt.total || 1;
				var index=opt.index || 0;
				var totalsize=(opt.totalsize ||0);
				var formData=new FormData();
				console.log("正在上传，请稍等。"+(index+1))
				if(isblob)
				{
					formData.append(that.file,data,name);
				}
				else
				{
					formData.append(that.file,data);
				}
				for(key in params)
				{
					formData.append(key,params[key]);
				}
				if(size!=0)
				{
					formData.append('size',size);
					formData.append('total',total);
					formData.append('index',index);
					formData.append('totalsize',totalsize);
				}
				$.ajax(
				{
					url:url+(url.indexOf('?')==-1?'?':'&')+'action='+action,
					type:'post',
					data:formData,
					contentType:false,
					processData:false,
					dataType:'json',
					xhr:function()
					{
						var xhr=$.ajaxSettings.xhr();
						xhr.upload.addEventListener('progress',function(e)
						{
							var rate=e.loaded/e.total;
							if(size>0)
							{
								var percent=(1/total);
								rate=(rate*percent+(index*percent));
							}
							rate=(rate*100).toFixed(2);
							that.msg({id:source,msg:'正在上传：'+rate+'%',time:0});
						})
						return xhr;
					},
					error:function(e)
					{
						that.msg({id:source,msg:'服务器出错，打开控制台查看'});
						console.log(e.responseText);
					},
					success:function(e)
					{
						if(e.state=='success')
						{
							success(e);
							that.msg({id:source,msg:'上传成功',time:3});
						}
						else
						{
							that.msg({id:source,msg:e.msg,time:5});
						}
					},
					complete:function(e,s)
					{
						$(source).find(".ui-upload-single").val('');
						console.log('上传结束');
					}
				});
			};

			that.ajaxUpList=function(opt)
			{
				var data=opt.data || {};
				var index=opt.index;
				var url=that.url || '';
				var success=opt.success || null;
				var tr=opt.source || '';
				var params=that.params || {};
				var isblob=opt.isblob || false;
				var name=opt.name || '';
				var size=opt.size || 0;
				var total=opt.total || 1;
				var num=opt.num || 0;
				var totalsize=(opt.totalsize ||0);
				var formData=new FormData();
				if(isblob)
				{
					formData.append(that.file,data,name);
				}
				else
				{
					formData.append(that.file,that.fileList[index][0]);
				}

				for(key in params)
				{
					formData.append(key,params[key]);
				}
				var target=$(".ui-upload-target").val() || '';
				if(target!='')
				{
					formData.append(that.key,target);
				}
				if(size!=0)
				{
					formData.append('size',size);
					formData.append('total',total);
					formData.append('index',num);
					formData.append('totalsize',totalsize);
				}
				$.ajax(
				{
					url:url,
					type:'post',
					data:formData,
					contentType:false,
					processData:false,
					dataType:'json',
					xhr:function()
					{
						var xhr=$.ajaxSettings.xhr();
						xhr.upload.addEventListener('progress',function(e)
						{
							var rate=e.loaded/e.total;
							if(size>0)
							{
								var percent=(1/total);
								rate=(rate*percent+(num*percent));
							}
							rate=(rate*100).toFixed(2);
							$(tr).find(".ui-progress").removeClass("ui-hide");
							$(tr).find(".ui-progress-bar").css({"width":rate+'%'}).html(rate+'%')
						})
						return xhr;
					},
					error:function(e)
					{
						that.fileList[index][3]=2;
						that.fileList[index][4]='失败';
						that.fileList[index][5]='系统错误';
						$(tr).attr("data-state",'2');
						$(tr).addClass("fail ui-upload-tips");
						$(tr).attr("data-title",'请查看控制台消息');
						console.log(e.responseText);
					},
					success:function(e)
					{
						if(e.state=='success')
						{
							success(e.msg);
							$(tr).attr("data-state",'3');
							if(num==total-1)
							{
								$(tr).attr("data-url",e.msg);
							}
							that.fileList[index][3]=3;
							that.fileList[index][4]='成功';
							that.fileList[index][6]=e.msg;
							$(tr).addClass("success");
							if($(tr).attr("data-type")=='img')
							{
								$(tr).find(".ui-preview").removeClass("ui-hide")
							}
							$(tr).find(".ui-preview").attr("href",e.msg);
						}
						else
						{
							that.fileList[index][3]=2;
							that.fileList[index][4]='失败';
							that.fileList[index][5]=e.msg;
							$(tr).attr("data-state",'2');
							$(tr).attr("data-title",e.msg);
							$(tr).addClass("fail ui-upload-tips");
						}
					},
					complete:function(e)
					{
						$(tr).find(".ui-progress").addClass("ui-hide");
						var complete=true;
						$(".ui-upload-tbody").find("li").each(function()
						{
							if($(this).attr("data-state")==1)
							{
								complete=false;
							}
						});
						if(complete)
						{
							if(size==0)
							{
								that.msg({id:'.ui-upload-begin',msg:'上传完成',time:3});
							}
							else
							{
								if(num==total-1)
								{
									that.msg({id:'.ui-upload-begin',msg:'上传完成',time:3});
								}
							}
						}
					}
				});
			};

			/*移除工具条*/
			that.removePop=function()
			{
				$(".ui-upload-popup").remove();
			};
			
			that.hasScrollbar=function() 
			{
  				return document.body.scrollHeight > (window.innerHeight || document.documentElement.clientHeight);
			};
			
			that.msg=function(opt)
			{
				that.tipsShow({text:opt.msg,id:opt.id,time:opt.time,tool:opt.tool,align:'top-left'});
			};

			that.tipsShow=function(opt)
			{
				that.tipsHide();
				opt.time=(opt.time) || 5;
				opt.tool=opt.tool || false;
				var e=$(opt.id);
				var x=0;
				var y=0;
				if(e.css("display")==undefined)
				{
					return;
				}
				if(opt.tool)
				{
					e=$(opt.id,that.tool);
				}
				if(e.length==0)
				{
					e=$(that.win);
				}
				var html=$('<div class="ui-upload-tips-show ui-upload-tips-show-'+opt.align+'">'+opt.text+'</div>');
				$("body").append(html);
				switch(opt.align)
				{
					case "top":
						x=e.offset().left - (html.outerWidth()/2) + e.outerWidth()/2 + ((that.hasScrollbar())?-10:2);
						y=e.offset().top-html.outerHeight()-10;
						break;
					case "top-left":
						x=e.offset().left;
						y=e.offset().top-html.outerHeight()-10;
						break;
				}
				if(e.hasClass("ui-upload-icon"))
				{
					x+=10;
				}
				html.css({"left":x+"px","top":y+"px","position":"absolute"});
				if(opt.time>0)
				{
					that.timer=setInterval(function()
					{
						$(".ui-upload-tips-show").remove();
					},opt.time*1000);
				}
			};
			
			that.tipsHide=function(opt)
			{
				clearInterval(that.timer);
				$(".ui-upload-tips-show").remove();
			};
			
			if(that.type=='all')
			{
				var html='';
				html+='<div class="ui-upload-multiple">';
				html+='<div class="ui-row ui-align-items-center">';
				html+='    <div class="ui-flex-fill"><div class="ui-btn">选择文件<input type="file"'+(that.multiple?' multiple':'')+' class="ui-upload-choose"></div><div class="ui-btn blue ui-ml ui-upload-begin">开始上传</div></div>';
				if(that.target.length>0)
				{
					html+='    <div class="ui-text-right ui-row ui-align-items-center">';
					html+='<div class="ui-text-gray">上传至：</div><div class="ui-flex-fill"><select class="ui-upload-target">';
					for(i=0;i<that.target.length;i++)
					{
						html+='<option value="'+that.target[i][0]+'" '+((that.target[i][2]==1)?'selected':'')+'>'+that.target[i][1]+'</option>';
					}
					html+='</select></div><div><a href="javascript:;" class="add-iframe ui-btn blue outline">添加分组</a></div></div>';
				}

				html+='</div>';
				html+='    <div class="ui-upload-body">';
				html+='        <div class="ui-upload-drop"><i class="ui-upload-icon-upload"></i>请将文件拖到此处</div>';
				html+='        <div class="ui-upload-list ui-hide"><ul></ul></div>';
				html+='    </div>';
				html+='</div>';
				
				$(that).html(html);
				
				var drop=$(".ui-upload-drop");
				var btn=$(".ui-upload-choose");
				var begin=$(".ui-upload-begin");
				var list=$(".ui-upload-list");
				var tbody=list.find("ul");

				var uploadFileList=function(obj)
				{
					if(obj.length<1)
					{
						return false;
					}
					if(!that.multiple && that.fileList.length==1)
					{
						that.msg({id:'.ui-upload-choose',msg:'仅可以上传<span class="ui-text-red ui-pl-sm ui-pr-sm">1</span>个文件',time:3});
						return false;
					}
					for(i=0;i<obj.length;i++)
					{
						var file=obj[i];
						var name=file.name;
						var size=file.size;
						var key=(name+size);
						var type=that.getType(file.type,name);
						if(that.filekey.indexOf(key)!=-1)
						{
							that.msg({id:'.ui-upload-choose',msg:'重复添加',time:3});
							continue;
						}
						var arr=[file,that.getName(name),size,1,'准备','','',type];
						if(parseFloat(size/1024/1024)>parseFloat(that.maxsize) && parseFloat(that.maxsize)>0)
						{
							arr[3]=2;
							arr[4]='失败';
							arr[5]='大小超出限制';
						}
						showFileList(arr);
						that.fileList.push(arr);
						that.filekey.push(key);
					}
					if(that.auto)
					{
						autoUpload();
					};
				};
				
				var showFileList=function(file)
				{
					var state='';
					switch(file[3])
					{
						case 2:
							state='fail ui-upload-tips';
							break;
						case 3:
							state='success';
							break;
					}
					var str=$('<li class="'+state+'" data-that="'+_self+'" data-title="'+file[5]+'" data-name="'+file[1]+'" data-state="'+file[3]+'" data-url="'+file[6]+'" data-type="'+file[7]+'"><div class="image"><img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw=="></div><div class="action"><a href="'+((file[3]!=3)?'javascript:;':file[6])+'" class="ui-icon-eye ui-preview ui-lightbox'+((file[3]!=3)?' ui-hide':'')+'" data-name="lightbox-'+file[1]+'" data-title="'+file[1]+'"></a><a href="javascript:;" class="ui-icon-delete"></a></div><div class="ui-progress big info radius striped ui-hide"><div class="ui-progress-bar" style="width:0%;">0%</div></div><div class="name ui-text-hide">'+file[1]+'</div></li>');
					tbody.append(str);
					var type=str.data("type");
					if(type=='img')
					{
						var thumb=160;
						var URL=window.URL || window.webkitURL;
						var blob=URL.createObjectURL(file[0]);
						var base64;
						var img=new Image();
						img.src=blob;
						img.onload=function()
						{
							var width=this.width;
							var height=this.height;
							var w=(width<thumb)?width:thumb;
							var h=(height<thumb)?height:thumb;
							h=w/width*height;
							var canvas=document.createElement('canvas');
							var ctx=canvas.getContext('2d');
							$(canvas).attr({width:w,height:h});
							ctx.drawImage(this,0,0,w,h);
							base64=canvas.toDataURL('image/jpeg',1);
							str.find(".image img").attr("src",base64);
						}
					}
					else
					{
						str.find(".image img").attr("src",'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAKAAAACgCAYAAACLz2ctAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAARISURBVHja7NrRjdpYGIBRT7QN0AJbApRgSiAleN7mlZQAr/MGJYQShhKGEkIJoQQWVr+VK8s2YEYsZs+RrCjMYCD+fK+vw8vhcMjgv/IiQASIAEGACBAEiABBgAgQBIgAQYAIEASIAEGACBAEiABBgAgQBIgAQYAIEASIAEGACBAEiABBgAgQAfpXQIAIEASIAEGACBAEiABBgAgQBIgAQYAIEASIAEGACBAEiABBgAgQBIgAQYAIEASIAEGACBAEiAARIAgQAYIAEeBje3t7+8rdzY7b9rhtWn6niN/7+w4fb3Tc8uO2aHntj3jPP+p28P7+3ptj+c05+O+B/BkHuatTJIeGLW/5WbotkwCLltcaxj5Xz/CP3/cADx23YbKP08g3TkaaLk4xvFS2TTy+qTw+OW77mt9/vWLEPvnV8NmKPh3Av/p+CdHw+OdxWyfT2Dm7ZIrLY4prCj6rxDtJnpfHtPgRkb02jGC7G6bnIt7rLnsCzzoFDyKALjYNo9Ou5vFJ5XmjJNLvLVPotuN7WyYn1UecaIUAH8+lo0zxxdPWJEbAQU045RQ5q7lm/HXBvqfx54/4bJM4MYoIMRfg48SXXTjKrOIgLmMh0lUa2DwZCQ/JNVt6nbiIabTu2m9VWfGWf1/HtWp1ATVOohTgnbStOsvR5PeZhUgaxviGaTGLiNLFR/n3bcOlwKyyEKq6dOWcrqB7GWBfFyGrltsQ8zi4+zgolyxEtrENz0yHh5ZRtG4kHsXINfriRVb1ZJz19Dg+5RRcZO03lc+thqsLjXLaG9f8rO32ybRlBOxqdkPMArxTfFmMOtc+73fN4qG8vlt3mKIXNddsWfIau46fbyDAx731MosDv7/yQOYxau4brtVek+ctb3yfeXJ5cO3nG8btl1yAj2cZB/aSa75p5dZLXjNqjuJ68jUJcxPPnd0Y4KBDyNOIdldz/VpeD//MenZf8NsTxXcK5vsVo8k+ObBZ5bpxEAdzUQlzF0HOr7wWKxc5RbzeOJ7/GfusLqg2lQVIeTIsGva9SBY+AwHed9otb8JOakaHvGV1um2YfgcxzZ32Vfdtk3UEc819w1W87jxOkvL+3T4eW585uT4jslUSZNPn2gjwPmbJLZNxTXzlQa+7T7hKApxWFhhF9ucrUXX33D4rt3zqQthX9leeJONKIJN47er/ZMwj8PKLE+NklFvEz899rl7o633APFlwLFqmvXPf3xvWrJoXF15HjpJpehSjZnl/cl0zdTbts/x/5n325z7kJt7/S8No+hRfxTrxjWgEiABBgAgQBIgAQYAIEASIAEGACBAEiABBgAgQBIgAQYAIEASIAEGACBAEiABBgAgQBIgAQYAIEAEKEAEiQBAgAgQBIkAQIAIEASJAECACBAEiQBAgAgQBIkAQIAIEASJAECACBAEiQBAgAgQBIkAQIAJEgCBABAgCRIAgQP4P/hFgAGANvn2gmoR3AAAAAElFTkSuQmCC');
					};
				};
				
				var autoUpload=function()
				{
					var num=0;
					var data=tbody.find("li");
					for(var index=0;index<data.length;index++)
					{
						var tr=data.eq(index);
						var state=$(tr).attr("data-state");
						var type=$(tr).attr("data-type");
						var name=$(tr).attr("data-name");
						if(state==1)
						{
							num++;
							var file=that.fileList[index][0];
							var name=file.name;
							var size=file.size;
							var type=that.getType(file.type,name);
							var fileSize=parseFloat(parseInt(size)/1024/1024).toFixed(2);
							var splitSize=that.minsize;
							var shardSize=splitSize*1024*1024;
							if(fileSize>=splitSize)
							{
								var total=Math.ceil(fileSize/splitSize);
								var upListSplit=function(file,index,tr,size,num,total,name,type,fileSize)
								{
									var start=num*shardSize;
									var end=Math.min(size,start+shardSize);
									var data=file.slice(start,end);
									that.ajaxUpList(
									{
										index:index,
										source:tr,
										data:data,
										isblob:true,
										name:name,
										size:size,
										total:total,
										num:num,
										totalsize:fileSize,
										success:function(e)
										{
											if(num==(total-1))
											{
												if(typeof that.success=="function")
												{
													that.success(that,{url:e,type:type,name:name});
												}
											}
											else
											{
												upListSplit(file,index,tr,size,num+1,total,name,type,fileSize);
											}	
										},
									});
								}
								upListSplit(file,index,tr,size,0,total,name,type,fileSize);
							}
							else
							{
								that.ajaxUpList(
								{
									index:index,
									source:tr,
									success:function(e)
									{
										if(typeof that.success=="function")
										{
											that.success(that,{url:e,type:type,name:name});
										}
									}
								})
							};
						}
					}
					if(num==0)
					{
						that.msg({id:'.ui-upload-begin',msg:'没有文件需要上传',time:3});
					}
				};
	
				drop.on("dragenter",function()
				{
					$(this).addClass("active");
				});
			
				drop.on("dragover",function()
				{
					return false;
				});
			
				drop.on("dragleave",function()
				{
					$(this).addClass("active");
				});
				
				drop.on("drop",function(e)
				{
					uploadFileList(e.originalEvent.dataTransfer.files);
					drop.addClass("ui-hide");
					list.removeClass("ui-hide");
					$(this).removeClass("active");
					return false;
				});
				
				drop.on("click",function(e)
				{
					btn.click();
				});
				
				drop.hover(function()
				{
					$(this).addClass("active");
				},function()
				{
					$(this).removeClass("active");
				});
	
				btn.on("change",function()
				{
					if($(this).val()=='')
					{
						return;
					}
					uploadFileList(this.files);
					drop.addClass("ui-hide");
					list.removeClass("ui-hide");
					btn.val('');
				});
				
				tbody.on("click","a.ui-icon-delete",function()
				{
					var tr=$(this).parents("li");
					var index=tr.index();
					tr.remove();
					that.fileList.splice(index,1);
					that.filekey.splice(index,1);
					if(that.fileList.length==0)
					{
						drop.removeClass("ui-hide");
						list.addClass("ui-hide");
					}
				});
				
				begin.on("click",function()
				{
					autoUpload();
				});
			}
			else
			{
				$(that).css({"position":"relative"});
				var accept='*';
				switch(that.accept)
				{
					case "image":
						accept='.gif,.jpg,.jpeg,.png,.webp';
						break;
					case "music":
						accept='.mp3';
						break;
					case "video":
						accept='.mp4';
						break;
					case "pdf":
						accept='.pdf';
						break;
					case "ppt":
						accept='.ppt,pptx';
						break;
					case "word":
						accept='.doc,.docx';
						break;
					case "excel":
						accept='.xls,.xlsx';
						break;
					case "zip":
						accept='.zip,.rar,.7z,.gz,.tar';
						break;
				}
				var file=$('<input type="file" tabindex="-1" '+(that.type=='more'?' multiple':'')+' accept="'+accept+'" class="ui-upload-single">');
				$(that).append(file);
				file.change(function()
				{
					for(i=0;i<file[0].files.length;i++)
					{
						var files=file[0].files[i];
						var name=files.name;
						var size=files.size;
						var type=that.getType(files.type,name);
						var fileSize=parseFloat(parseInt(size)/1024/1024).toFixed(2);
						if(parseFloat(fileSize)>parseFloat(that.maxsize) && parseFloat(that.maxsize)>0)
						{
							that.msg({id:that,msg:'大小超出限制',time:5});
							return;
						}
						if(that.zip && (files.type=='image/jpeg' || files.type=='image/png') && fileSize>1)
						{
							var filename=(files.type=='image/jpeg')?'ui.jpg':'ui.png';
							that.crop(that,files,type,name,filename,fileSize);
						}
						else
						{
							var splitSize=that.minsize;
							var shardSize=splitSize*1024*1024;
							if(fileSize>=splitSize)
							{
								var total=Math.ceil(fileSize/splitSize);
								var uploadSplit=function(files,size,index,total,name,type,fileSize)
								{
									var start=index*shardSize;
									var end=Math.min(size,start+shardSize);
									var data=files.slice(start,end);
									that.ajaxUpload(
									{
										data:data,
										isblob:true,
										name:name,
										size:size,
										total:total,
										index:index,
										totalsize:fileSize,
										action:that.accept,
										source:that,
										success:function(e)
										{
											if(index==(total-1))
											{
												if(typeof that.success=="function")
												{
													that.success(that,{url:e.msg,type:type,name:that.getName(name)});
												}
											}
											else
											{
												uploadSplit(files,size,index+1,total,name,type,fileSize);
											}	
										},
									});
								}
								uploadSplit(files,size,0,total,name,type,fileSize);
							}
							else
							{
								that.ajaxUpload(
								{
									data:files,
									action:that.accept,
									source:that,
									success:function(e)
									{
										if(typeof that.success=="function")
										{
											that.success(that,{url:e.msg,type:type,name:that.getName(name)});
										}
									},
								});
							}
						}
					}
				});
			};
			
			/*工具提示效果*/
			$(document).off("mouseenter",".ui-upload-tips").on("mouseenter",".ui-upload-tips",function()
			{
				if(!$(this).hasClass("ui-upload-disabled"))
				{
					var align=$(this).data("align") || '';
					var id=$(this).data("that");
					var that=$("#"+id)[0];
					align=(align=='')?'top':align;
					if($(this).data("title")!='')
					{
						that.msg({msg:$(this).data("title"),id:this,align:align});
					}
				}
			});
			
			$(document).off("mouseleave",".ui-upload-tips").on("mouseleave",".ui-upload-tips",function()
			{
				var id=$(this).data("that");
				var that=$("#"+id)[0];
				that.tipsHide();
			});
			
			$(document).off("click",".ui-upload-tips").on("click",".ui-upload-tips",function()
			{
				var id=$(this).data("that");
				var that=$("#"+id)[0];
				that.tipsHide();
			});
			
		});
	};
	
})(jQuery);